var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { TokenCounter } from '../tokenCount/tokenCount.js';
import { aggregateMetrics } from './aggregateMetrics.js';
import { calculateAllFileMetrics } from './calculateAllFileMetrics.js';
export const calculateMetrics = (processedFiles, output, progressCallback, config) => __awaiter(void 0, void 0, void 0, function* () {
    const tokenCounter = new TokenCounter(config.tokenCount.encoding);
    progressCallback('Calculating metrics...');
    const fileMetrics = yield calculateAllFileMetrics(processedFiles, tokenCounter, progressCallback);
    const result = aggregateMetrics(fileMetrics, processedFiles, output, tokenCounter);
    tokenCounter.free();
    return result;
});
//# sourceMappingURL=calculateMetrics.js.map